#define _CRT_DISABLE_PERFCRIT_LOCKS
#define FASTIO ios_base::sync_with_stdio(false); cin.tie(NULL); cout.tie(NULL)
#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int bodovanje(vector<pair<int, int>> tacke, int pogox, int pogoy)
{
    int bodovi = 0;
    for (int i = 0; i < tacke.size(); i++)
    {
        bodovi += abs(tacke[i].first - pogox) * abs(tacke[i].second - pogoy);
    }
    return bodovi;
}

int Partition(vector<int>& v, int start, int end)
{
    int pivot = end;
    int j = start;
    for (int i = start; i < end; ++i)
    {
        if (v[i] < v[pivot])
        {
            swap(v[i], v[j]);
            ++j;
        }
    }
    swap(v[j], v[pivot]);
    return j;
}

void Sort(vector<int> &v, int start, int end)
{
    if (start < end)
    {
        int p = Partition(v, start, end);
        Sort(v, start, p - 1);
        Sort(v, p + 1, end);
    }
}

int main()
{
    FASTIO;
    int brojTacaka;
    vector<pair<int, int>> tacke;
    vector<int> resenja;
    vector<int> xkor, ykor;

    cin >> brojTacaka;
    for (int i = 0; i < brojTacaka; i++)
    {
        int temp1, temp2;
        cin >> temp1 >> temp2;
        tacke.push_back({ temp1, temp2 });
    }

    resenja.push_back(0);

    for (int i = brojTacaka - 2; i >= 0; i--)
    {
        xkor.clear();
        ykor.clear();
        vector<pair<int, int>> korisne = vector<pair<int, int>>(tacke.begin(), tacke.end() - i);

        int x, y;

        for (int j = 0; j < korisne.size(); j++)
        {
            xkor.push_back(korisne[j].first);
            ykor.push_back(korisne[j].second);
        }
        vector<int> potRes;

        for (int x = 0; x < xkor.size(); x++)
        {
            for (int y = 1; y < ykor.size(); y++)
            {
                potRes.push_back(bodovanje(korisne, xkor[x], ykor[y]));
            }
        }

        Sort(potRes, 0, potRes.size() - 1);

        resenja.push_back(potRes[potRes.size() - 1]);

    }

    for (int i = 0; i < resenja.size(); i++)
    {
        cout << resenja[i] << '\n';
    }

}